@extends('layouts.dashboard')

{{-- Dynamic site title --}}
@if( Request::get('term') )
    @section('title', 'Search for '.  Request::get('term') . ' | ' . Options::get('title')  )
@else
    @section('title', ucwords($view) . ' Tickets | ' . Options::get('title')  )
@endif


@section('content')

<div class="content">
    <div class="row content-body">

        <!-- TICKETS BOX -->
        <div class="ticket-box-row-first">
            <div class="col-md-12  ticket-big-box-col">
                <div class="ticket-big-box s-ticket-p recent-ticket-box">
                    <div class="box-title">
                        <div class="title-text pull-left">
                            @if( Request::get('term') )
                                <h3> Showing Search results for <i>'{{ Request::get('term') }}'</i> </h3>
                            @else
                                <h3> {{ $view }} Tickets</h3>
                            @endif
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover  responsive-table">
                            <thead>
                                <tr>
                                    <th>Ticket ID</th>
                                    <th>Ticket title</th>
                                    <th>Department</th>
                                    <th>Date</th>
                                    <th>Client</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>

                            {{-- Check if there's any tickets --}}
                            @if( count($tickets) )
                                {{-- Loop through over the tickets --}}
								@foreach( $tickets as $ticket )
    
		                            <tr class="ticket_row">
		                                <td>#{{ $ticket->id }}</td>
	                                	<td>
	                                    	<a href="{!! route('dashboard.single.ticket', [
                                                'subject' => $ticket->FormatSubject(), 
                                                'id' => $ticket->id
                                            ]) !!}">
	                                    		{{ str_limit($ticket->subject, 30) }}
	                                    	</a>
	                                    </td>
		                                <td>{{ $ticket->getDepartment() }}</td>
		                                <td>{{ $ticket->created_at->diffForHumans() }}</td>
		                                <td>{{ $ticket->user->fullName() }}</td>
		                                <td>
		                                    <span class="status-{{ $ticket->status }}">
		                                    	{{ ucwords($ticket->status) }}
		                                    </span>
		                                </td>
                                        <td>
                                            <button class="ticket_remove remove-btn" type="submit" value="{{ $ticket->id }}"><i class="fa fa-times"></i></button>
                                        </td>
		                            </tr>

								@endforeach
                                {{-- End the Loop --}}
	
                            @else
                                
                                {{-- If no rows found --}}
                            	<tr>
                            		<td colspan="7" align="center"> No tickets found. </td>
                            	</tr>
                            	
                            @endif
                            {{-- End the if condiction --}}

                        </table>                              
                    </div>
                </div>

                {{ $tickets->appends(['term' => Request::get('term')])->render() }}
                
            </div>
        </div>

    </div>
</div>


@stop
