<!doctype html>
<html class="no-js" lang="">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <title> <?php echo $__env->yieldContent('title'); ?> </title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="apple-touch-icon" href="apple-touch-icon.png">
        <!-- Place favicon.ico in the root directory -->
        
        <!-- <link href="https://fonts.googleapis.com/css?family=Montserrat:400,700" rel="stylesheet"> -->

        <!-- NORMALIZING CSS -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/normalize.css')); ?>">

        <!-- ICONIC FONT - FONT AWESOME -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/font-awesome.min.css')); ?>">

        <!-- Animate CSS-->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/animate.css')); ?>">

        <!-- SWEET ALERT FOR CUSTOM ALERT -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/sweetalert.css')); ?>">

        <!-- BOOTSTRAP FRONTEND FRAMEWORD -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/bootstrap.css')); ?>">

        <!-- LOAD WEB FONTS -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/font-stylesheet.css')); ?>">

        <!-- MAIN STYLESHEET FILE -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/style.css')); ?>">

        <!-- RESPONSIVE STYLESHEET -->
        <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/responsive.css')); ?>">

        <style>
            <?php echo Options::get('extra_css'); ?>

        </style>

        <!-- MODERNIZER -->
        <script src="<?php echo e(URL::asset('assets/js/vendor/modernizr-2.8.3.min.js')); ?>"></script>

        <?php echo $__env->yieldContent('head_scripts'); ?>

        <script>
            var loginStatus = <?php echo Auth::check() ? "'logged'" : "'not'"; ?>;
            var siteUrl = '<?php echo e(url("/")); ?>';
            var token = '<?php echo e(csrf_token()); ?>';
        </script>

    </head>
    <body class="<?php echo $__env->yieldContent('body_class'); ?>">
        <!--[if lt IE 8]>
            <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->
        


        <!--====================================
        =            NAVBAR STARTS            =
        =====================================-->

        <?php echo $__env->make('partials.site.nav', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        

        <!--====  End of NAVBAR  ====-->


        <!--====================================
        =            CONTENT STARTS            =
        =====================================-->

        <div class="content-area">
            <?php echo $__env->yieldContent('content'); ?>
        </div>

        <!--====  End of CONTENT  ====-->
        
        
        


        <!-- LOAD JQUERY  -->
        <script src="<?php echo e(URL::asset('assets/js/vendor/jquery-1.12.0.min.js')); ?>"></script>

        <!-- BOOTSTRAP JS -->
        <script src="<?php echo e(URL::asset('assets/js/bootstrap.js')); ?>"></script>

        <!-- SWEETALERT JS -->
        <script src="<?php echo e(URL::asset('assets/js/sweetalert.min.js')); ?>"></script>
        
        <!-- CUSTOM SCRIPT FILE -->
        <script src="<?php echo e(URL::asset('assets/js/main.js')); ?>"></script>

        <!-- SOME COMMON SCRIPTS FOR BACKEND AND FRONTEND -->
        <script src="<?php echo e(URL::asset('assets/js/commonScripts.js')); ?>"></script>
        <?php echo $__env->yieldContent('script'); ?>
        
    </body>
</html>
