<?php $__env->startSection('title', 'All tickets | ' . Options::get('title') ); ?>

<?php $__env->startSection('content'); ?>

<div class="container all-tickets-area">

    <div class="ticket-area">

                    <div class="ticket-big-box ticket-box all-user-ticket-box">
                        <div class="box-title">
                            <div class="title-text">
                                <h3>All Tickets</h3>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover  responsive-table">
                                <thead>
                                    <tr>
                                        <th>Ticket ID</th>
                                        <th>Ticket title</th>
                                        <th>Department</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <?php if( count($tickets) ): ?>

                                    <?php foreach($tickets as $ticket): ?>
    	                                <tr class="ticket_row">
    	                                    <td>#<?php echo e($ticket->id); ?></td>
    	                                    <td>
    	                                    	<a href="<?php echo e(route('single.ticket', [
                                                    'subject' => $ticket->FormatSubject(), 
    	                                    		'id' => $ticket->id
                                                ])); ?>">
    	                                    		<?php echo e(str_limit($ticket->subject, 30)); ?>

    	                                    	</a>
    	                                    </td>
    	                                    <td><?php echo e($ticket->getDepartment()); ?> </td>

    	                                     <!-- Check If the date is over 1 month or not -->
                                            <?php $date = $ticket->created_at; ?>
                                            <td> 
                                                <?php echo e($date->diffInMonths(Carbon::now()) >= 1 ? $date->format('j M Y, g:ia') : $date->diffForHumans()); ?> 
                                            </td>

    	                                    <td>
    	                                        <span class="status-<?php echo e($ticket->status); ?>"> <?php echo e(ucwords($ticket->status)); ?> </span>
    	                                    </td>
    	                                    <td class="action-btns">
                                                <a href="<?php echo e(route('single.ticket', [
                                                    'subject' => $ticket->FormatSubject(), 
                                                    'id' => $ticket->id
                                                ])); ?>" title="View">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                                
                                                <?php $editAbility = Options::get('edit_ticket'); ?>
                                                <?php if( $editAbility == 'on'): ?>
    	                                    	      <a href="<?php echo e(route('edit.ticket', $ticket->id)); ?>"  title="Edit"><i class="fa fa-edit"></i></a>
                                                <?php endif; ?>
    	                                    	<button type="submit" class="ticket_remove remove-btn" value="<?php echo e($ticket->id); ?>" title="Delete">
                                                    <i class="fa fa-times"></i>
                                                </button> 
    	                                    </td>
    	                                </tr>
                                    <?php endforeach; ?>


                                <?php else: ?>
                                    <td colspan="6" align="center"> Nothing to show. </td>
                                <?php endif; ?>
                            </table>                              
                        </div>
                    </div>



                    <!-- Pagination -->
                   <?php echo e($tickets->render()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>