<?php $active = app('App\Http\Utilities\Active'); ?>

            <!--=====================================
            =            MAIN SIDEBAR STARTS            =
            ======================================-->
            <aside class="main-sidebar">
                <section class="sidebar">
                    <div class="menu-label">
                        <p>Main Menu</p>
                    </div>

                    <ul class="sidebar-menu">
                        <li class="<?php echo e($active::set(['dashboard'])); ?>">
                            <a href="<?php echo e(route('dashboard.index')); ?>">
                                <img src="<?php echo e(URL::asset('assets/img/icons/icon-dashboard.png')); ?>" alt="" class="menu-icon">
                                <span class="title">Dashboard</span>
                            </a>
                        </li>
                        <li class="has-dropdown <?php echo e($active::set(['dashboard/tickets*'])); ?>">
                            <a href="">
                                <img src="<?php echo e(URL::asset('assets/img/icons/icon-file.png')); ?>" alt="" class="menu-icon">
                                <span class="title">Tickets</span>

                                <?php if( $new_ticket_count !== 0): ?>
                                    <span class="menu-label label-new"><?php echo e($new_ticket_count); ?></span>
                                <?php endif; ?>
                                <i class="arrow-icon fa fa-angle-down"></i>
                            </a>
                            <div class="sidebar-dropdown-menu">
                                <ul>
                                    <li><a href="<?php echo e(route('dashboard.tickets', 'all')); ?>">
                                        <i class="fa fa-circle-thin"></i>
                                        All Tickets 
                                        <?php if( $all_ticket_count !== 0): ?>
                                            <span class="menu-label label-all"><?php echo e($all_ticket_count); ?></span>
                                        <?php endif; ?>
                                    </a></li>
                                    <li><a href="<?php echo e(route('dashboard.tickets', 'new')); ?>">
                                        <i class="fa fa-circle-thin"></i>
                                        New Tickets 
                                        <?php if( $new_ticket_count !== 0): ?>
                                            <span class="menu-label label-new"><?php echo e($new_ticket_count); ?></span>
                                        <?php endif; ?>
                                    </a></li>
                                    <li><a href="<?php echo e(route('dashboard.tickets', 'pending')); ?>">
                                        <i class="fa fa-circle-thin"></i>
                                        Pending Tickets
                                        <?php if( $pending_ticket_count !== 0): ?>
                                            <span class="menu-label label-pending"><?php echo e($pending_ticket_count); ?></span>
                                        <?php endif; ?>
                                    </a></li>
                                    <li><a href="<?php echo e(route('dashboard.tickets', 'solved')); ?>">
                                        <i class="fa fa-circle-thin"></i>
                                        Solved tickets
                                        <?php if( $solved_ticket_count !== 0): ?>
                                            <span class="menu-label label-solved"><?php echo e($solved_ticket_count); ?></span>
                                        <?php endif; ?>
                                    </a></li>
                                </ul>
                            </div>
                            
                        </li>
                        <li class="has-dropdown <?php echo e($active::set(['dashboard/staffs*'])); ?>">
                            <a href="">
                                <img src="<?php echo e(URL::asset('assets/img/icons/icon-profile.png')); ?>" alt="" class="menu-icon">
                                <span class="title">Staffs</span>
        
                                <?php if( $new_staffs_count !== 0): ?>
                                    <span class="menu-label label-new"><?php echo e($new_staffs_count); ?></span>
                                <?php endif; ?>

                                <i class="arrow-icon fa fa-angle-down"></i>
                            </a>

                            <div class="sidebar-dropdown-menu">
                                <ul>
                                    <li><a href="<?php echo e(route('dashboard.staffs.all')); ?>">
                                        <i class="fa fa-circle-thin"></i>
                                        All Staffs

                                        <?php if( $all_staffs_count !== 0): ?>
                                            <span class="menu-label label-all"><?php echo e($all_staffs_count); ?></span>
                                        <?php endif; ?>
                                    </a></li>
                                    <li><a href="javascript:void(0)" class="md-trigger hidden-xs" data-modal="newStaff">
                                        <i class="fa fa-circle-thin"></i>
                                        New Staffs
                                    </a></li>
                                    <li><a href="<?php echo e(route('dashboard.staffs.create')); ?>" class="visible-xs">
                                        <i class="fa fa-circle-thin"></i>
                                        New Staffs
                                    </a></li>
                                </ul>
                            </div>
                        </li>
                        <li class="has-dropdown <?php echo e($active::set(['dashboard/clients*'])); ?>">
                            <a href="">
                                <img src="<?php echo e(URL::asset('assets/img/icons/icon-clients.png')); ?>" alt="" class="menu-icon">
                                <span class="title">Clients</span>

                                <?php if( $new_clients_count !== 0): ?>
                                    <span class="menu-label label-new"><?php echo e($new_clients_count); ?></span>
                                <?php endif; ?>


                                <i class="arrow-icon fa fa-angle-down"></i>

                            </a>
                
                            <div class="sidebar-dropdown-menu">
                                <ul>
                                    <li><a href="<?php echo e(route('dashboard.clients.all')); ?>">
                                        <i class="fa fa-circle-thin"></i>
                                        All Clients

                                        <?php if( $all_clients_count !== 0): ?>
                                            <span class="menu-label label-all"><?php echo e($all_clients_count); ?></span>
                                        <?php endif; ?>

                                    </a></li>
                                    <li><a href="javascript:void(0)" class="md-trigger" data-modal="newClient">
                                        <i class="fa fa-circle-thin"></i>
                                        New Clients
                                    </a></li>
                                </ul>
                            </div>

                        </li>
                        <li class=" <?php echo e($active::set(['dashboard/settings*'])); ?> ">
                            <a href="<?php echo e(route('dashboard.settings.index')); ?>">
                                <img src="<?php echo e(URL::asset('assets/img/icons/icon-settings.png')); ?>" alt="" class="menu-icon">
                                <span class="title">Settings</span>
                            </a>
                        </li>
                    </ul>
                </section>
            </aside>
            <!--====  End of SIDEBAR  ====-->