<?php $__env->startSection('title', 'All Staffs | ' . Options::get('title') ); ?>

<?php $__env->startSection('content'); ?>

                <div class="content">
                    <div class="row content-body">
                        
                        <!--  STAFF BOX -->
                        <div class="ticket-box-row-first">
                            <div class="col-md-12  ticket-big-box-col">
                                <div class="staffs-p">
                                    <div class="box-title">
                                        <div class="title-text pull-left">
                                            <h3>Staffs</h3>
                                        </div>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-hover responsive-table">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th>Department</th>
                                                    <th class=" text-center">staff Image</th>
                                                    <th>Assigned Ticket</th>
                                                    <th>Solved Ticket</th>
                                                    <th >Registered at</th>
                                                    <th class="text-center">Action</th>
                                                </tr>
                                            </thead>

                                            <?php if( count($staffs) ): ?>

                                            	<?php foreach($staffs as $staff): ?>

		                                            <tr class="staff_row">
		                                                <td><?php echo e($staff->fullName()); ?></td>
                                                        <td><a href="mailto:<?php echo e($staff->email); ?>"><?php echo e($staff->email); ?></a></td>
                                                        <td><?php echo e($staff->getDepartmentName()); ?></td>
		                                                <td class="text-center tbl-img">
		                                                    <img src="<?php echo e($staff->profileImg(50)); ?>" alt="">
		                                                </td>
                                                        <td><?php echo e($staff->assignedTickets()->count()); ?></td>
                                                        <td><?php echo e($staff->solvedTickets()->count()); ?></td>
		                                                <td><?php echo e($staff->created_at->diffForHumans()); ?></td>
		                                                <td class=" text-center tbl-btn">
                                                            <!-- Not for Mobile Browser -->
                                                            <button class="staff_edit edit-btn md-trigger hidden-xs" data-modal="editStaff" value="<?php echo e($staff->id); ?>">
                                                                <i class="fa fa-edit"></i>
                                                            </button>

                                                            <!-- Only for Mobile Browser -->
                                                            <a href="<?php echo e(route('dashboard.staffs.getPageEdit', $staff->id)); ?>" class="staff_edit edit-btn visible-xs">
                                                                <i class="fa fa-edit"></i>
                                                            </a>

                                                            <button class="staff_remove remove-btn"  type="submit" value="<?php echo e($staff->id); ?>">
                                                                <i class="fa fa-times"></i>
                                                            </button>
		                                                </td>
		                                            </tr>

	                                            <?php endforeach; ?>

                                            <?php else: ?>
                                            	<tr>
                                            		<td colspan="8" align="center"> No staffs to show. </td>
                                            	</tr>
                                            <?php endif; ?>

                                        </table>                              
                                    </div>

                                </div>

                                <!-- Pagination -->
                                <?php echo e($staffs->render()); ?>

                            </div>
                        </div>

                    </div>
                </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>